package gov.va.genisis2.vo;

import gov.va.genisis2.model.CommentHistory;

import java.util.Date;
import java.util.List;

/**
 * The Class RequestHistory.
 */
public class RequestHistory {

	/** The title. */
	private String title;
	
	/** The description. */
	private String description;
	
	/** The status description. */
	private String statusDescription;
	
	/** The created on. */
	private Date createdOn;
	
	/** The created by. */
	private String createdBy;
	
	/** The modified on. */
	private Date modifiedOn;
	
	/** The modified by. */
	private String modifiedBy;

	/** The comment history. */
	List<CommentHistory> commentHistory;

	/**
	 * Instantiates a new request history.
	 */
	public RequestHistory() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new request history.
	 *
	 * @param title the title
	 * @param description the description
	 * @param statusDescription the status description
	 * @param createdOn the created on
	 * @param createdBy the created by
	 * @param modifiedOn the modified on
	 * @param modifiedBy the modified by
	 * @param commentHistory the comment history
	 */
	public RequestHistory(String title, String description, String statusDescription, Date createdOn, String createdBy,
			Date modifiedOn, String modifiedBy, List<CommentHistory> commentHistory) {
		super();
		this.title = title;
		this.description = description;
		this.statusDescription = statusDescription;
		this.createdOn = createdOn;
		this.createdBy = createdBy;
		this.modifiedOn = modifiedOn;
		this.modifiedBy = modifiedBy;
		this.commentHistory = commentHistory;
	}

	/**
	 * Gets the title.
	 *
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the status description.
	 *
	 * @return the status description
	 */
	public String getStatusDescription() {
		return statusDescription;
	}

	/**
	 * Sets the status description.
	 *
	 * @param statusDescription the new status description
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	public Date getCreatedOn() {
		return createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the comment history.
	 *
	 * @return the comment history
	 */
	public List<CommentHistory> getCommentHistory() {
		return commentHistory;
	}

	/**
	 * Sets the comment history.
	 *
	 * @param commentHistory the new comment history
	 */
	public void setCommentHistory(List<CommentHistory> commentHistory) {
		this.commentHistory = commentHistory;
	}

	/**
	 * Gets the modified on.
	 *
	 * @return the modified on
	 */
	public Date getModifiedOn() {
		return modifiedOn;
	}

	/**
	 * Sets the modified on.
	 *
	 * @param modifiedOn the new modified on
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the modified by.
	 *
	 * @return the modified by
	 */
	public String getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * Sets the modified by.
	 *
	 * @param modifiedBy the new modified by
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

}
